function [FA, FAl, FAr]=fuzzinessIT2(A)

%
% [FA, FAl, FAr]=fuzzinessIT2(A)
%
% To compute the fuzziness of an IT2 FS, which is defined by nine
% parameters (a, b, c, d, e, f, g, i, h) shown in Fig. 1 of Readme.doc. 
%
% D. Wu and J.M. Mendel, "Uncertainty measures for interval type-2 fuzzy
% set," Information Sciences, 177, pp. 5378-5393, 2007.
%
% J. M. Mendel and Dongrui Wu, Perceptual Computing: Aiding People in Making Subjective Judgments, 
% Wiley-IEEE Press, 2010.
%
% Dongrui WU (dongruiw@usc.edu), 3/24/2009
%
% A: an IT2 FS represented by 9 parameters.
% FA: center of fuzziness of A
% FAl: left bound of the fuzziness
% FAr: right bound of the fuzziness

N=100;
Xs=linspace(A(1),A(4),N);
UMF=mg(Xs,A(1:4),[0 1 1 0]);
LMF=mg(Xs,A(5:8),[0 A(9) A(9) 0]);
Al=zeros(1,N);
Ar=zeros(1,N);
for i=1:N
    if abs(UMF(i)-.5)>abs(LMF(i)-.5)
        Al(i)=UMF(i);
    end
    if UMF(i)<.5
        Ar(i)=UMF(i);
    elseif LMF(i)>.5
        Ar(i)=LMF(i);
    else
        Ar(i)=.5;
    end
end 
FAl=1-sum(abs(2*Al-1))/N;
FAr=1-sum(abs(2*Ar-1))/N;
FA=(FAl+FAr)/2;
